// Sketcher.cpp : Definiuje zachowanie klas w aplikacji
//

#include "stdafx.h"
#include "Sketcher.h"
#include "MainFrm.h"

#include "ChildFrm.h"
#include "SketcherDoc.h"
#include "SketcherView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSketcherApp

BEGIN_MESSAGE_MAP(CSketcherApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, &CSketcherApp::OnAppAbout)
	// Standardowe polecenia dla dokumentu opartego na plikach
	ON_COMMAND(ID_FILE_NEW, &CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, &CWinApp::OnFileOpen)
	// Standardowe polecenie konfiguracji drukowania
	ON_COMMAND(ID_FILE_PRINT_SETUP, &CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()


// Konstrukcja CSketcherApp

CSketcherApp::CSketcherApp()
{
	// DO ZROBENIA: Tutaj dodaj kod konstrukcji
	// Znaczce inicjalizacje powinny by umieszczane w InitInstance
}


// Jeden jedyny obiekt CSketcherApp

CSketcherApp theApp;


// Inicjalizacja CSketcherApp

BOOL CSketcherApp::InitInstance()
{
	// InitCommonControlsEx() jest wymagane w Windows XP, jeeli manifest
	// aplikacji okrela wykorzystanie ComCtl32.dll w wersji 6 lub pniejszej
	// do obsugi stylw wizualnych. W przeciwnym razie tworzenie jakiegokolwiek okna nie powiedzie si.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Tutaj naley umieci wszystkie klasy kontrolek wsplnych, ktre maj by
	// w aplikacji.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

	// Inicjalizacja bibliotek OLE.
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	// Standardowa inicjalizacja
	// Jeeli nie korzystasz z tych moliwoci i chcesz zmniejszy
	// rozmiar kocowy pliku wykonywalnego, powiniene usun z poniszej czci
	// niepotrzebne procedury inicjalizacyjne.
	// Zmiana klucza rejestru, w ktrym przechowywane s ustawienia.
	// DO ZROBIENIAi: naley zmieni ten acuch na bardziej odpowiedni,
	// taki jak na przykad nazwa organizacji
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));
	LoadStdProfileSettings(4);  // aduje standardowe ustawienia z pliku INI (wcznie z MRU).
	// Rejestracja szablonw dokumentw aplikacji. Szablony dokumentw
	//  su jako cznik midzy dokumentami, oknami ramowymi i widokami.
	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(IDR_SketcherTYPE,
		RUNTIME_CLASS(CSketcherDoc),
		RUNTIME_CLASS(CChildFrame), // Niestandardowe okno ramowe MDI
		RUNTIME_CLASS(CSketcherView));
	if (!pDocTemplate)
		return FALSE;
	AddDocTemplate(pDocTemplate);

	// tworzy gwne okno ramowe MDI
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame || !pMainFrame->LoadFrame(IDR_MAINFRAME))
	{
		delete pMainFrame;
		return FALSE;
	}
	m_pMainWnd = pMainFrame;
	// Wywouj DragAcceptFiles, tylko jeeli jest rozszerzenie.
	//  W aplikacji MDI naley to umieci zaraz po ustawieniu  m_pMainWnd
	// Wcza otwieranie przez przeciganie i upuszczanie
	m_pMainWnd->DragAcceptFiles();

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Wyszukuje w wierszu polece standardowe polecenia powok, DDE, otwrz plik.
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);


	// Przesya polecenia podane w wierszu polece. Zwraca FALSE,
	// jeeli aplikacja zostaa uruchomiona z opcj /RegServer, /Register, /Unregserver lub /Unregister.
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
	// Gwne okno zostao zainicjalizowane, wic poka je i zaktualizuj.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}



// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementacja
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

// App command to run the dialog
void CSketcherApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// Procedury obsugi komunikatw CSketcherApp

